define(['app'], function (app) {
	"use strict";
	app.controller('HeaderController', function ($scope, $state, authenticationService, config) {
		$scope.$on("$stateChangeSuccess", function(event, toState, toParams, fromState){
			$scope.title = config.app.title;
			if (/two-panel\.secondary-navigation/.test(toState.name) && $state.current.data && $state.current.data.moduleName) {
				$scope.title = config.app.title + ' - ' + $state.current.data.moduleName
			}

			$scope.showHomeButton = authenticationService.isAuthenticated() && $state.current.name != 'main.auth.home';
			if ($state.current.data && $state.current.data.homeName) {
				$scope.homeTitle = $state.current.data.homeName;
			} else {
				$scope.homeTitle = "";
			}

			$scope.headerTitle = config.app.title;
			if ($state.current.data && $state.current.data.moduleName) {
				$scope.headerTitle += ' - ' + $state.current.data.moduleName;
			}

		});

		$scope.goHome = function() {
			$state.go('main.auth.home');
		};
	});
});
